'use strict';
viewer.directive('ngEnter', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keypress", function (event) {
            if(event.which === 13) {
                scope.$apply(function (){
                    scope.$eval(attrs.ngEnter);
                });

                event.preventDefault();
            }
        });
    };
});



viewer.directive('multibookFrame', function () {
    return {
        restrict: "A",
        replace: true,
        scope: {
            frame: "=",
            singlePageWidth: "="
        },
        controller: function($scope, $rootScope, StructureJson){
            $scope.$on('Window:resize', function(broadcast, width){
                $scope.scale = $scope.getScale();
                $scope.setElementProperties();
                $scope.$apply();
            });


            $scope.getScale = function(){
                if($rootScope.forceOnePage)
                {
                    return getScale($rootScope.pageMaxWidth, $rootScope.pageMaxHeight, StructureJson.getPageWidth(), StructureJson.getPageHeight());
                }
                else
                {
                    return getScale($rootScope.pageMaxWidth, $rootScope.pageMaxHeight, 2 * StructureJson.getPageWidth(), StructureJson.getPageHeight());
                }
            }

            $scope.scale = $scope.getScale();



            $scope.setElementProperties = function(){
                $scope.element.css('left', $scope.scale * $scope.frame.getX() - 1);
                $scope.element.css('top', $scope.scale * $scope.frame.getY() - 1);
                $scope.element.css('width', $scope.scale * $scope.frame.getWidth());
                $scope.element.css('height', $scope.scale * $scope.frame.getHeight());
                $scope.element.css('border-color', $scope.frame.getActivity().getColor());
            }


            $scope.openContent = function(){
                $scope.$parent.openActivity($scope.frame.getActivity());
            }
        },
        link: function(scope, element, params){
            scope.element = element;
            scope.setElementProperties();

            var string = '<ol>';
            angular.forEach(scope.frame.getActivity().getContents(), function(Content){
                string += '<li >' + Content.getTitle() + '</li>';
            })
            string += '</ol>';
//
//            element.popover({
//                content: string,
//                html: true,
//                trigger: 'manual',
//                placement: 'auto right',
//                container: 'body'
//            });
//
//            element.mouseover(function(){
//                element.popover('show');
//            });
//
//            element.mouseout(function(){
//                element.popover('hide');
//            });

            element.enableTouch();

            element.on('tap', function(event){
                event.stopPropagation();
                scope.openContent();
                scope.$apply();
            });

        },
        templateUrl: debugModeUrl + 'js/partials/directives/multibook-frame.html'
    };
});



viewer.directive('galleryImage', function () {
    return {
        restrict: "A",
        replace: true,
        scope: {
            content: "=",
            isSelected: "="
        },
        controller: function($scope, $rootScope){
            $scope.goNextImg = function(){
                $scope.$parent.goNextImg();
            }
            $scope.goPrevImg = function(){
                $scope.$parent.goPrevImg();
            }
        },
        link: function(scope, element, params){
            element.enableTouch();

            element.on('swipeLeft', function(event){
                event.stopPropagation();
                scope.goNextImg();
                scope.$apply();
            });

            element.on('swipeRight', function(event){
                event.stopPropagation();
                scope.goPrevImg();
                scope.$apply();
            });
        },
        templateUrl: debugModeUrl + 'js/partials/directives/gallery-image.html'
    };
});


/**
 * Dyrektywa pozwalająca przesuwać strony gestami przy rozkładówce
 */
viewer.directive('pageSlider', function () {
    return {
        restrict: "A"
        ,scope: {
            leftPage: '='
            ,rightPage: '='
        }
        ,controller: function($scope){
            $scope.goToNextPage = function(){
                if($scope.rightPage)
                {
                    $scope.$parent.goToNextPage();
                }
            }

            $scope.goToPreviousPage = function(){
                if($scope.leftPage)
                {
                    $scope.$parent.goToPreviousPage();
                }
            }
        }
        ,link: function(scope, element, params){
            element.enableTouch();

            element.on('swipeLeft', function(event){
                event.stopPropagation();
                scope.goToNextPage();
                scope.$apply();
            });

            element.on('swipeRight', function(event){
                event.stopPropagation();
                scope.goToPreviousPage();
                scope.$apply();
            });
        }
    };
});



viewer.directive('onePageSlider', function (StructureJson) {
    return {
        restrict: "A"
        ,link: function(scope, element, params){

//            element.css('width', StructureJson.getPageWidth());
//            element.css('height', StructureJson.getPageHeight());

            element.enableTouch();

            element.on('swipeLeft', function(event){
                event.stopPropagation();
                scope.$parent.goToNextPage();
                scope.$apply();
            });

            element.on('swipeRight', function(event){
                event.stopPropagation();
                scope.$parent.goToPreviousPage();
                scope.$apply();
            });
        }
    };
});

viewer.directive('showMenu', function ($timeout, $rootScope) {
    return {
        restrict: "A"
        ,controller: function($scope){
            $scope.$on('Navigation:focus', function(){
                $timeout.cancel($scope.timeOut);
            });
        }
        ,link: function(scope, element, params){
            element.enableTouch();

            element.on('tap', function(event){
                event.stopPropagation();
                if($rootScope.navigationBarOpen)
                {
                    $rootScope.$broadcast('Navigation:hideBar');
                }
                else
                {
                    $rootScope.$broadcast('Navigation:showBar');
                    scope.timeOut = $timeout(function(){
                        $rootScope.$broadcast('Navigation:hideBar');
                    }, 5000);
                }

                scope.$apply();
            });

            /**
             * Propgate swipe ewents to parent elements
             */
            element.on('swipeLeft', function(){

            });
            element.on('swipeRight', function(){

            });
        }
    };
});
